﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CashierCrisis.Behaviors;

namespace BehaviorTreeEditor
{
    public class BehaviorFactory
    {
        public Behavior Create(string behaviorName)
        {
            switch (behaviorName)
            {
                case "Sequence":
                    return new Sequence();
                case "Selector":
                    return new Selector();
                case "Parallel":
                    return new Parallel();
                case "Timer":
                    return new Timer();
                case "Repeat":
                    return new Repeat();
                case "Wait":
                    return new Wait();
            }
            throw new ArgumentException("No such behavior exists.");
        }
    }
}
